<?php
// SETTINGS
$STORE_FILE = __DIR__ . '/chat_buffer.json';

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);

file_put_contents(__DIR__ . '/log.txt', date('Y-m-d H:i:s') . ' - ' . $raw . PHP_EOL, FILE_APPEND);

$userId = $data['data']['message']['user_id'] ?? null;
$text = $data['data']['message']['message_parts'][0]['text']['content'] ?? null;

if (!$userId || !$text) {
    http_response_code(400);
    exit('Invalid request');
}

$buffer = file_exists($STORE_FILE) ? json_decode(file_get_contents($STORE_FILE), true) : [];
$buffer[$userId]['messages'][] = $text;
$buffer[$userId]['last_time'] = time();
file_put_contents($STORE_FILE, json_encode($buffer));

http_response_code(200);
echo 'OK';
