<?php
$STORE_FILE = __DIR__ . '/chat_buffer.json';
$VOICEFLOW_API_KEY = 'YOUR_VOICEFLOW_API_KEY';
$FRESHCHAT_API_KEY = 'YOUR_FRESHCHAT_API_KEY';

$buffer = file_exists($STORE_FILE) ? json_decode(file_get_contents($STORE_FILE), true) : [];

foreach ($buffer as $uid => $session) {
    if (time() - $session['last_time'] >= 60) {
        $combined = implode('. ', $session['messages']);
        $reply = sendToVoiceflow($uid, $combined, $VOICEFLOW_API_KEY);

        // Log the Voiceflow reply
        file_put_contents(__DIR__ . '/voiceflow_replies.txt', "[$uid] Sent: $combined
Reply: $reply

", FILE_APPEND);

        sendToFreshchat($uid, $reply, $FRESHCHAT_API_KEY);
        unset($buffer[$uid]);
    }
}

file_put_contents($STORE_FILE, json_encode($buffer));
echo "Flush complete";

function sendToVoiceflow($userId, $message, $apiKey) {
    $url = "https://general-runtime.voiceflow.com/state/user/{$userId}/interact";
    $payload = [
        "action" => ["type" => "text", "payload" => $message],
        "config" => ["tts" => false, "stripSSML" => true]
    ];
    $res = callApi($url, $payload, [
        "Authorization: Bearer $apiKey",
        "Content-Type: application/json"
    ]);
    return $res['data'][0]['payload']['message'] ?? 'Sorry, no response.';
}

function sendToFreshchat($userId, $message, $apiKey) {
    $url = "https://api.freshchat.com/v2/app/users/{$userId}/messages";
    $payload = [
        "message_parts" => [["text" => $message]]
    ];
    callApi($url, $payload, [
        "Authorization: Bearer $apiKey",
        "Content-Type: application/json"
    ]);
}

function callApi($url, $data, $headers) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS => json_encode($data),
        CURLOPT_HTTPHEADER => $headers,
        CURLOPT_POST => true
    ]);
    $res = curl_exec($ch);
    curl_close($ch);
    return json_decode($res, true);
}
